#!/bin/bash
#SBATCH --mem=10G
#SBATCH --cpus-per-task=4
#SBATCH --time=12:00:00              # Time limit hrs:min:sec
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/IN1k/yfcc-NF-NP-%a.out    # Standard output and error log
#SBATCH --open-mode=A
#SBATCH --partition=compute
#SBATCH --constraint=10GbE
#SBATCH --job-name=yfcc
#SBATCH --array=6,7,8,9,10,11,57,58,59,60,51

cd /users/yuki/adiwol/experts/IN1k

echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*100000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*100000))

in_file=_tmp_yfcc-NF-NP_train_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/data/fast/yfcc-noface-noperson/IN1k/'
mkdir -p ${results_dir}

< /scratch/shared/beegfs/yuki/data/YFCC-17M-noface-noperson-fixed.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

/scratch/shared/beegfs/yuki/envs/py37/bin/python main_pretrained_model.py \
                                                  --input_txt=${in_file} \
                                                  --save_folder=${results_dir} \
                                                  --cpu

